*** COS 2019 02, last update 2023 04  
           
program define dq_fil_res, rclass  
syntax , [srdd(string) reportname(string) segmentname(string) targetfiles(string) resultreport(int 0) breakreport(int 0) benchmark(int 0)  indent(int 0)]  
local indent=`indent'+5  
local adoname "dq_fil_res"  
local text_i "di as text _n "  					  
local filenumber=0					  
local reportstop=0					  
local join=0						  
tokenize `targetfiles'																  
while "`1'"~="" {  
	local file="`1'"  
	          
	local filenumber=`filenumber'+1													  
	if `filenumber'>1 & `reportstop'==0 local join=1 								  
	dq_fil_exc, cdir("`srdd'") cfile(`file'.dta) filetype(Result data) join(`join')  indent(`indent')  
	local reportstop = r(reportstop)												  
	          
	if `filenumber' == 1 & `reportstop'==0 {  
		capture drop file_nr														  
		qui gen file_nr=.															  
		lab var file_nr "Number of result file loaded"  
	}	        
	          
	if `filenumber' > 1 & `reportstop'==0 {  
		capture replace file_nr=`filenumber' if filenr==. 							  
	}	        
		         
	macro shift																		  
}	         
if `reportstop'==0 {  
	local resultvarformat=0															  
	tempvar checkvar  
	capture egen `checkvar'=rowmiss(reportname segmentname dataset_initalobsnum pointer)  
	if _rc==0 {																		  
		if sum(`checkvar')==0  {													  
			local resultvarformat=1													  
		}        
	}         
	drop `checkvar'  
	          
	if `resultvarformat'==0 {  
		local reportstop=1  
		*** DQ_quality_decision: 	DQ_INT_11  
		`text_i' "CRITICAL WARNING: $DQ_INT_critical_11 No result file format specified for `file'"  
		dq_out_add,  tablename(integtable_studydata) row(integtablerows_studydata) columns(3) ///  
										colcontent1("$Critical_1") colcontent2("Result file format.") colcontent3($DQ_INT_critical_11)  indent(`indent') 	  
	}         
	if `resultvarformat'==1 {  
		local stratalist ""  
		qui capture ds vp_N_*  
		local varlist "`r(varlist)'"  
		foreach  var of local varlist  {  
				local structure=subinstr("`var'","vp_N_","",1)  
				local stratalist `"`stratalist' `structure'"'  
		}        
		`text_i' "The detected list of structural objects is `stratalist'"  
		local clustervars ""  
		local ctype "ob de ce"  
		capture qui ds icc*dqi  
		if "`r(varlist)'"~="" { 		  
			local varlist "`r(varlist)'"  
			        
			foreach st of local stratalist  {  
				foreach ct of local ctype  {  
					foreach var of local varlist {  
						if strpos("`var'","`st'_`ct'")>0 & strpos("`clustervars'","`ct'")==0 {  
							local clustervars=trim("`clustervars' `ct'")  
							local stub=substr("`var'",1,strpos("`var'","`st'_`ct'")-1)  
							capture drop `stub'`st'_`ct'_dqi  
							qui egen `stub'`st'_`ct'_dqi=rowmax(`stub'`st'_`ct'*_dqi)  
						}    
					}     
				}      
			}       
		}        
		if "`segmentname'" == "" local segmentname segmentname		  
		dq_int_var1 , varchecklist(`segmentname') tablename(integtable_studydata) row(integtablerows_studydata) breakreport(`breakreport') vartype(9)   indent(`indent')  
		if "`r(varchecklist)'"=="" 	local reportstop=1			  
		qui encode segmentname, gen(segment)  
	          
	}         
	if `reportstop' == 0  & `filenumber'>1 {  
		local targetfiles "`reportname'_allresultsover_`segmentname'"  
		save "`srdd'\`targetfiles'.dta", replace  
	}         
}          
tempvar pointercheck sortorder  
gen `sortorder'=_n						  
bysort pointer: gen `pointercheck'=_n  
sort `sortorder'						  
qui sum `pointercheck'  
if r(max)>2 { 	  
	tempvar sortordernew  
	gen `sortordernew'=_n  
	replace pointer=int((`sortordernew'+1)/2)  
	          
	drop `pointercheck' `sortorder' `sortordernew'  
	save "`srdd'\`targetfiles'.dta", replace  
}          
*** Load previous results into scalars  
dq_fil_met, sd("`srdd'") metadatafile("`targetfiles'.dta") infotype(4) segmentname(segment) benchmark(`benchmark')  indent(`indent')  
if `r(reportstop)'==1 {  
	local reportstop=1  
}          
if `reportstop'==0 {  
	foreach vartype in idvars keyvars minorvars processvars controlvars observervars devicevars centervars timevars  {  
		if "`r(`vartype')'"~=""  local `vartype' "`r(`vartype')'" 			  
		return local `vartype'="``vartype''" 								  
	}         
}          
*** Drop potentially problematic scalars or empty scalars  
local scalarlist: all scalars  
foreach scal of local scalarlist {  
	if "`=`scal''"=="." | "`=`scal''"==""  	scalar drop `scal'		  
	if strpos("`scal'","pointer")>0 	 	scalar drop `scal'		  
	if strpos("`scal'","modified")>0 		scalar drop `scal'		  
}          
return local allclvars= "`clustervars'"  
return local reportstop=`reportstop'						  
end        
